import matplotlib.pyplot as plt


plt.rcParams['font.family'] = 'Times New Roman'


nodes = [5, 10, 15, 20, 30, 50, 100]

# Our method
our_method_case1_loss = [0.2232, 0.2233, 0.2235, 0.2234, 0.2232, 0.2234, 0.2235]
our_method_case1_acc = [0.8724, 0.8721, 0.8726, 0.8721, 0.8721, 0.8718, 0.8721]

our_method_case2_loss = [0.2277, 0.2418, 0.2411, 0.2421, 0.2411, 0.2404, 0.2419]
our_method_case2_acc = [0.8657, 0.8535, 0.8530, 0.8531, 0.8529, 0.8540, 0.8533]

our_method_case3_loss = [0.2235, 0.2231, 0.2230, 0.2231, 0.2244, 0.2231, 0.2229]
our_method_case3_acc = [0.8716, 0.8751, 0.8734, 0.8751, 0.8717, 0.8751, 0.8735]

our_method_case4_loss = [0.2375, 0.2403, 0.2385, 0.2390, 0.2389, 0.2391, 0.2382]
our_method_case4_acc = [0.8537, 0.8481, 0.8509, 0.8508, 0.8504, 0.8497, 0.8508]

# FedProx 
fedprox_case1_loss = [0.2315, 0.2320, 0.2314, 0.2323, 0.2317, 0.2325, 0.2317]
fedprox_case1_acc = [0.8576, 0.8581, 0.8603, 0.8574, 0.8591, 0.8577, 0.8580]

fedprox_case2_loss = [0.2347, 0.2423, 0.2436, 0.2430, 0.2433, 0.2432, 0.2427]
fedprox_case2_acc = [0.8545, 0.8502, 0.8494, 0.8491, 0.8492, 0.8490, 0.8492]

fedprox_case3_loss = [0.2474, 0.2460, 0.2439, 0.2490, 0.2453, 0.2428, 0.2409]
fedprox_case3_acc = [0.8456, 0.8517, 0.8508, 0.8501, 0.8530, 0.8482, 0.8499]

fedprox_case4_loss = [0.2384, 0.2404, 0.2398, 0.2395, 0.2396, 0.2400, 0.2406]
fedprox_case4_acc = [0.8511, 0.8496, 0.8508, 0.8504, 0.8501, 0.8496, 0.8486]


label_fontsize = 30 
tick_fontsize = 25 
legend_fontsize = 16 

plt.figure(figsize=(10, 6))


plt.plot(nodes, our_method_case1_loss, label='Our method - Case 1', marker='o', color='blue')
plt.plot(nodes, our_method_case2_loss, label='Our method - Case 2', marker='o', color='orange', linestyle='dashed')
plt.plot(nodes, our_method_case3_loss, label='Our method - Case 3', marker='o', color='green', linestyle='dotted')
plt.plot(nodes, our_method_case4_loss, label='Our method - Case 4', marker='o', color='red', linestyle='dashdot')


plt.plot(nodes, fedprox_case1_loss, label='FedProx - Case 1', marker='s', color='purple')
plt.plot(nodes, fedprox_case2_loss, label='FedProx - Case 2', marker='s', color='brown', linestyle='dashed')
plt.plot(nodes, fedprox_case3_loss, label='FedProx - Case 3', marker='s', color='pink', linestyle='dotted')
plt.plot(nodes, fedprox_case4_loss, label='FedProx - Case 4', marker='s', color='cyan', linestyle='dashdot')

plt.xlabel('Number of Learners n', fontsize=label_fontsize)
plt.ylabel('Loss Value', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)
plt.tight_layout()


plt.savefig('loss_plot_nodes.png', dpi=300, bbox_inches='tight')
plt.savefig('loss_plot_nodes.svg', format='svg', bbox_inches='tight')
plt.savefig('loss_plot_nodes.pdf', format='pdf', bbox_inches='tight')
plt.show()


plt.figure(figsize=(10, 6))


plt.plot(nodes, our_method_case1_acc, label='Our method - Case 1', marker='o', color='blue')
plt.plot(nodes, our_method_case2_acc, label='Our method - Case 2', marker='o', color='orange', linestyle='dashed')
plt.plot(nodes, our_method_case3_acc, label='Our method - Case 3', marker='o', color='green', linestyle='dotted')
plt.plot(nodes, our_method_case4_acc, label='Our method - Case 4', marker='o', color='red', linestyle='dashdot')


plt.plot(nodes, fedprox_case1_acc, label='FedProx - Case 1', marker='s', color='purple')
plt.plot(nodes, fedprox_case2_acc, label='FedProx - Case 2', marker='s', color='brown', linestyle='dashed')
plt.plot(nodes, fedprox_case3_acc, label='FedProx - Case 3', marker='s', color='pink', linestyle='dotted')
plt.plot(nodes, fedprox_case4_acc, label='FedProx - Case 4', marker='s', color='cyan', linestyle='dashdot')

plt.xlabel('Number of Learners n', fontsize=label_fontsize)
plt.ylabel('Prediction Accuracy', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)
plt.tight_layout()


plt.savefig('accuracy_plot_nodes.png', dpi=300, bbox_inches='tight')
plt.savefig('accuracy_plot_nodes.svg', format='svg', bbox_inches='tight')
plt.savefig('accuracy_plot_nodes.pdf', format='pdf', bbox_inches='tight')
plt.show()
